#ifndef OBJECTPAIR_H
#define OBJECTPAIR_H
#include "object.h"
#include <set>

struct ObjectPair
{
public:
    ObjectPair(Object object1, Object object2);
    ObjectPair(Object object1, Object object2, int overlap);

    vector<Token> object1;
    vector<Token> object2;
    double final_score;

    bool operator < (const ObjectPair& obj) const;    //pairs with bigger final score go first
    bool operator == (const ObjectPair& obj) const;

private:
    int countOverlap(vector<Token>& object1, vector<Token>& object2);   //count overlap of two objects
    double countSim(int object1_size, int object2_size, int overlap);   //count similarity of two objects

};

#endif // OBJECTPAIR_H
